package plugins;
use Exporter;
use Time::Local;
use RRDs;

@ISA = qw(Exporter);


@EXPORT = qw(init_plugins obtain_info create_rrd update_rrd check_warn );


sub init_plugins {
  my %conf;

  # default for CPU
  $conf{"CPU"}{"FIXED"}=0;
  $conf{"CPU"}{"DATA"}="GAUGE";
  $conf{"CPU"}{"LABLE"}="CPU of Host";
  $conf{"CPU"}{"U_EXPONENT"}=0;
  $conf{"CPU"}{"FORMAT"}="%6.2lf%%";
  $conf{"CPU"}{"L_LIMIT"}=0;
  $conf{"CPU"}{"V_LABLE"}=" ";
  $conf{"CPU"}{"ALERT_LIMIT_WARN"}=2;
  $conf{"CPU"}{"ALERT_LIMIT_CRIT"}=5;

  # CPU for win32 machines
  $conf{"CPU.WIN"}{"FIXED"}=0;
  $conf{"CPU.WIN"}{"DATA"}="GAUGE";
  $conf{"CPU.WIN"}{"LABLE"}="CPU of Host";
  $conf{"CPU.WIN"}{"V_LABLE"}="%";
  $conf{"CPU.WIN"}{"U_EXPONENT"}=0;
  $conf{"CPU.WIN"}{"FORMAT"}="%6.2lf%%";
  $conf{"CPU.WIN"}{"L_LIMIT"}=0;
  $conf{"CPU.WIN"}{"U_LIMIT"}=100;
  $conf{"CPU.WIN"}{"ALERT_LIMIT_WARN"}=95;
  $conf{"CPU.WIN"}{"ALERT_LIMIT_CRIT"}=99;

  # default for MEM 
  $conf{"MEM"}{"FIXED"}=0;
  $conf{"MEM"}{"DATA"}="GAUGE";
  $conf{"MEM"}{"LABLE"}="Memory of Host";
  $conf{"MEM"}{"V_LABLE"}="%";
  $conf{"MEM"}{"U_EXPONENT"}=0;
  $conf{"MEM"}{"FORMAT"}="%6.2lf%%";
  $conf{"MEM"}{"L_LIMIT"}=0;
  $conf{"MEM"}{"U_LIMIT"}=100;
  $conf{"MEM"}{"ALERT_LIMIT_WARN"}=96;
  $conf{"MEM"}{"ALERT_LIMIT_CRIT"}=99;

  # default for PROC
  $conf{"PROC"}{"FIXED"}=0;
  $conf{"PROC"}{"DATA"}="GAUGE";
  $conf{"PROC"}{"LABLE"}="Processes of Host";
  $conf{"PROC"}{"U_EXPONENT"}=0;
  $conf{"PROC"}{"FORMAT"}="%6.0lf";
  $conf{"PROC"}{"L_LIMIT"}=0;
  $conf{"PROC"}{"V_LABLE"}="n";

  # default for NETB
  $conf{"NETB"}{"FIXED"}=0;
  $conf{"NETB"}{"DATA"}="DERIVE:600:0:U";
  $conf{"NETB"}{"LABLE"}="Network of Host";
  $conf{"NETB"}{"V_LABLE"}="bits/s";
  $conf{"NETB"}{"L_MODIFY"}="1000,/";
  $conf{"NETB"}{"FORMAT"}="%6.0lf k";
  $conf{"NETB"}{"L_LIMIT"}=0;

  # default for NETI
  $conf{"NETI"}{"FIXED"}=0;
  $conf{"NETI"}{"DATA"}="DERIVE:600:0:U";
  $conf{"NETI"}{"LABLE"}="Interface of Host";
  $conf{"NETI"}{"V_LABLE"}="packets/s";
  $conf{"NETI"}{"FORMAT"}="%6.0lf";
  $conf{"NETI"}{"L_LIMIT"}=0;

  # default for DISK
  $conf{"DISK"}{"FIXED"}=0;
  $conf{"DISK"}{"DATA"}="GAUGE";
  $conf{"DISK"}{"LABLE"}="Disk of Host";
  $conf{"DISK"}{"V_LABLE"}="%";
  $conf{"DISK"}{"U_EXPONENT"}=0;
  $conf{"DISK"}{"FORMAT"}="%6.2lf%%";
  $conf{"DISK"}{"L_LIMIT"}=0;
  $conf{"DISK"}{"U_LIMIT"}=100;
  $conf{"DISK"}{"ALERT_LIMIT_WARN"}=95;
  $conf{"DISK"}{"ALERT_LIMIT_CRIT"}=99;


  # default for DSPEED
  $conf{"DSPEED"}{"FIXED"}=0;
  $conf{"DSPEED"}{"DATA"}="GAUGE";
  $conf{"DSPEED"}{"LABLE"}="Disk Speed of Host";
  $conf{"DSPEED"}{"V_LABLE"}="bytes/s";
  $conf{"DSPEED"}{"L_MODIFY"}="1000,/";
  $conf{"DSPEED"}{"FORMAT"}="%6.0lf k";
  $conf{"DSPEED"}{"L_LIMIT"}=0;

  # default for SAR
  $conf{"SAR"}{"FIXED"}=0;
  $conf{"SAR"}{"DATA"}="GAUGE";
  $conf{"SAR"}{"LABLE"}="SAR of Host";
  $conf{"SAR"}{"V_LABLE"}="%";
  $conf{"SAR"}{"U_EXPONENT"}=0;
  $conf{"SAR"}{"FORMAT"}="%6.2lf%%";
  $conf{"SAR"}{"L_LIMIT"}=0;
  $conf{"SAR"}{"U_LIMIT"}=100;
  $conf{"SAR"}{"ALERT_LIMIT_WARN"}=95;
  $conf{"SAR"}{"ALERT_LIMIT_CRIT"}=99;
  $conf{"SAR"}{"GRAPH_TYPE"}="AREA";


  \%conf;
};

sub obtain_info {
  my %info;
  my @atemp;
  my ($home_dir,$host)=@_;
  if ( -f "$home_dir/data/$host/info2" ){
    open(FL,"$home_dir/data/$host/info2");
    @atemp=<FL>;close(FL);
    foreach $atmp (@atemp){
     chomp($atmp);
     ($lable,$value)=split(/\=/,$atmp);
     $info{$lable}=$value;
    }
  }
  \%info;
}


sub create_rrd {
  my ($file,$type,$number)=@_;
  my %atype;
  my $start=time();
  my $tmp;
  my @rrd_out;

  for($tmp=0;$tmp < $number;$tmp++){
    if ( $type =~ /:/ ){
      push @rrd_out,"DS:$tmp:$type";
    }else{
      push @rrd_out,"DS:$tmp:$type:600:U:U";
    }
  }

  RRDs::create ($file, "--start",$start-1, "--step",300,
              @rrd_out,
              "RRA:AVERAGE:0.5:1:600",
              "RRA:AVERAGE:0.5:6:700",
              "RRA:AVERAGE:0.5:24:775",
              "RRA:AVERAGE:0.5:288:797",
              "RRA:MAX:0.5:1:600 ",
              "RRA:MAX:0.5:6:700 ",
              "RRA:MAX:0.5:24:775",
              "RRA:MAX:0.5:288:797",
              "RRA:MIN:0.5:1:600 ",
              "RRA:MIN:0.5:6:700 ",
              "RRA:MIN:0.5:24:775",
              "RRA:MIN:0.5:288:797"
              );
}

sub update_rrd {
  my ($file,@values)=@_;
  my $start=time();
  my $tmp=join(":",@values);
  $tmp=~ s/^://gi;$tmp=~ s/:$//gi;
  RRDs::update $file, "$start:".$tmp;
#open(FL,">>/tmp/hoax");
#print FL "RRDs::update $file, \"$start:\".$tmp\n";
#print FL RRDs::error,"\n";
#close(FL);
}


sub check_warn {
  my ($file,$plugin,$format,$warn,$crit,$lables,@inp)=@_;
  my $crit_f="";
  my $warn_f="";
  my (@lable)=split(/\,/,$lables);
  open(FL2,">>$file");
  my $cnt=0;
  foreach $i (@inp){
    if (( $crit ne "" ) and  ( $i > $crit )){
      $i=int($i*100)/100;
      $crit_f="$crit_f $lable[$cnt] > $i $format ,";
    }elsif (( $warn ne "" ) and  ( $i > $warn )){
      $i=int($i*100)/100;
      $warn_f="$warn_f $lable[$cnt] > $i $format ,";
    }
    $cnt++;
  }
  $crit_f=~  s/\,$//gi;$warn_f=~  s/\,$//gi;
  if ( $crit_f ne "" ){
    print FL2 "$plugin:\:CRITICAL:\:$crit_f:\:\n";
  }
  if ( $warn_f ne "" ){
    print FL2 "$plugin:\:WARNING:\:$warn_f:\:\n";
  }
  close(FL2);
}



1;
